<?php
ob_start();
session_start();
require 'fpdf/fpdf.php';
include 'conexao.php';

$ano_letivo = $_POST['ano_letivo'] ?? '';
$alunos_selecionados = $_POST['alunos'] ?? [];

// Garantir máximo de 6 alunos
$alunos_selecionados = array_slice($alunos_selecionados, 0, 6);

// Preencher até 6 posições
while (count($alunos_selecionados) < 6) {
    $alunos_selecionados[] = null;
}

$dados_alunos = [];
foreach ($alunos_selecionados as $id) {
    if (!$id) {
        $dados_alunos[] = null;
        continue;
    }

    $stmt = $conn->prepare("
        SELECT a.nome, a.numero_processo, a.foto, 
               t.classe, t.nome AS turma, t.curso, t.turno
        FROM matriculas m
        JOIN alunos a ON a.id = m.aluno_id
        JOIN turmas t ON t.id = m.turma_id
        WHERE m.aluno_id = ? AND m.ano_letivo = ?
        LIMIT 1
    ");
    $stmt->bind_param("is", $id, $ano_letivo);
    $stmt->execute();
    $res = $stmt->get_result();
    $dados = $res->fetch_assoc();

    if ($dados) {
        $dados['ano_letivo'] = $ano_letivo;
    }

    $dados_alunos[] = $dados ?: null;
}

// Iniciar PDF
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

// Função para gerar cartão
function gerarCartao($pdf, $x, $y, $dados_aluno, $numero) {
    $pdf->SetDrawColor(150);
    $pdf->SetFillColor(245);
    $pdf->Rect($x, $y, 90, 72, 'DF');

    $cabecalhoAltura = 25;

    // 1. Insígnia
    $pdf->Image('insignia/insigniacartao.png', $x + 30, $y + 2, 14);

    // 2. Cabeçalho oficial
    $pdf->SetFont('Arial', 'B', 6.5);
    $pdf->SetXY($x + 2, $y + 14);
    $pdf->Cell(75, 4, utf8_decode("REPÚBLICA DE ANGOLA"), 0, 1, 'C');
    $pdf->Cell(82, 4, utf8_decode("GOVERNO PROVINCIAL DE BENGUELA"), 0, 1, 'C');
    $pdf->Cell(82, 4, utf8_decode("GABINETE PROVINCIAL DA EDUCAÇÃO"), 0, 1, 'C');

    // 3. Nome da escola
    $pdf->SetFont('Arial', 'B', 6);
    $pdf->Cell(82, 4, utf8_decode("COMPLEXO ESCOLAR BG 0026 PADRE EMIL FRICK - CATUMBELA"), 0, 1, 'C');

    // 4. Foto do aluno
    if (!empty($dados_aluno['foto']) && file_exists('fotos/' . $dados_aluno['foto'])) {
        $pdf->Image('fotos/' . $dados_aluno['foto'], $x + 70, $y + 2, 16, $cabecalhoAltura - 4);
    } else {
        $pdf->Rect($x + 70, $y + 2, 16, $cabecalhoAltura - 4); // Moldura vazia
    }

    // 5. Nº do Processo IND.
    $pdf->SetXY($x + 18, $y + 30);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(85, 5, utf8_decode("Nº Proc. Ind."), 0, 1, 'C');

    // 6. Título do cartão
    $pdf->SetX($x + 1);
    $ano = $dados_aluno['ano_letivo'] ?? '____';
    $pdf->Cell(100, 5, utf8_decode("CARTÃO DE ESTUDANTE Nº ______/{$ano}"), 0, 1, 'C');

    // Corpo
    $pdf->SetFont('Arial', '', 7);

    // Nome
    $nome_aluno = $dados_aluno['nome'] ?? 'N/D';
    $pdf->SetXY($x + 4, $y + 40);
    $pdf->Cell(0, 5, utf8_decode("Nome: $nome_aluno"), 0, 1, 'L');

    // Linha com todos os dados
    $pdf->SetXY($x + 4, $y + 48);
    $classe_aluno = $dados_aluno['classe'] ?? 'N/D';
    $turma_aluno = $dados_aluno['turma'] ?? 'N/D';
    $num_aluno = $dados_aluno['numero_processo'] ?? 'N/D';
    $curso_aluno = $dados_aluno['curso'] ?? 'N/D';
    $turno_aluno = $dados_aluno['turno'] ?? 'N/D';

    $linha = utf8_decode("Classe: {$classe_aluno}ª    Turma: {$turma_aluno}    Nº: {$num_aluno}    Curso: $curso_aluno    Período: $turno_aluno");
    $pdf->Cell(0, 5, $linha, 0, 1, 'L');

    // Assinaturas
    $pdf->SetXY($x + 4, $y + 55);
    $pdf->SetFont('Arial', '', 6.5);
    $pdf->Cell(40, 4, utf8_decode("O(A) ALUNO(A)"), 0, 0, 'C');
    $pdf->Cell(40, 4, utf8_decode("O DIRECTOR"), 0, 1, 'C');

    $pdf->SetXY($x + 4, $y + 58);
    $pdf->Cell(40, 4, "________________", 0, 0, 'C');
    $pdf->Cell(40, 4, "__________________", 0, 0, 'C');
}

// Posições dos 6 cartões
$positions = [
    [10, 30], [110, 30],
    [10, 120], [110, 120],
    [10, 210], [110, 210],
];

for ($i = 0; $i < 6; $i++) {
    gerarCartao($pdf, $positions[$i][0], $positions[$i][1], $dados_alunos[$i], $i + 1);
}

// Verso dos cartões
$pdf->AddPage();
function gerarVersoCartao($pdf, $x, $y) {
    $pdf->SetDrawColor(150);
    $pdf->SetFillColor(245);
    $pdf->Rect($x, $y, 90, 60, 'DF');

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY($x + 5, $y + 4);
    $pdf->Cell(80, 6, utf8_decode("CONTROLO DE PROPINA"), 0, 1, 'C');

    $pdf->SetFont('Arial', '', 7);
    $meses = [
        "Setembro/2024", "Outubro/2024", "Novembro/2024", "Dezembro/2024",
        "Janeiro/2025", "Fevereiro/2025", "Março/2025", "Abril/2025",
        "Maio/2025", "Junho/2025", "Julho/2025"
    ];

    $yLinha = $y + 12;
    foreach ($meses as $mes) {
        $linha = utf8_decode("{$mes} ________ Data:__/___/____  Ass:___________");
        $pdf->SetXY($x + 5, $yLinha);
        $pdf->Cell(0, 4, $linha, 0, 1, 'L');
        $yLinha += 4;
    }
}

// Mesmas posições para o verso
$positions = [
    [10, 15], [110, 15],
    [10, 95], [110, 95],
    [10, 175], [110, 175],
];

for ($i = 0; $i < 6; $i++) {
    gerarVersoCartao($pdf, $positions[$i][0], $positions[$i][1]);
}

ob_end_clean();
$pdf->Output();
exit;
?>
